function saveTextAsFile(textToWrite, fileNameToSaveAs)
    {
    	var textFileAsBlob = new Blob([textToWrite], {type:'text/s  css'});
    	var downloadLink = document.createElement("a");
    	downloadLink.download = fileNameToSaveAs;
    	downloadLink.innerHTML = "Download File";
    	if (window.webkitURL != null)
    	{
    		// Chrome allows the link to be clicked
    		// without actually adding it to the DOM.
    		downloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);
    	}
    	else
    	{
    		// Firefox requires the link to be added to the DOM
    		// before it can be clicked.
    		downloadLink.href = window.URL.createObjectURL(textFileAsBlob);
    		downloadLink.onclick = destroyClickedElement;
    		downloadLink.style.display = "none";
    		document.body.appendChild(downloadLink);
    	}

    	downloadLink.click();
    }

var script = {
  data() {
    return {
      editor: null
    };
  },
  mounted() {
    this.editor = ace.edit("editor");
    this.editor.setTheme("ace/theme/monokai");
    this.editor.session.setMode("ace/mode/scss");
    this.editor.setValue(CInterop.loadFromConfig())

    // listen for ctrl + s on the window
    window.addEventListener("keydown", (e) => {
      if (e.ctrlKey && e.key === "s") {
        this.saveToClient();
      }
    })
  },
  methods: {
    readFiles() {
      this.$refs.filePicker.click();
    },
    exportFile() {
      saveTextAsFile(this.editor.getValue(), prompt("Enter a file name, followed by .scss"));
    },
    async read(_input) {
      console.log("READ", this.$refs.filePicker.files);
      function readFile(file) {
        return new Promise((resolve, _reject) => {
          const fr = new FileReader();
          fr.onload = () => resolve(fr.result);
          fr.readAsText(file);
        });
      }
      this.editor.setValue(await readFile(this.$refs.filePicker.files[0]));
    },
    saveToClient() {
      CInterop.save(this.editor.getValue())
      //alert(this.editor.getValue());
    }
  }
};

function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    // Vue.extend constructor export interop.
    const options = typeof script === 'function' ? script.options : script;
    // render functions
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        // functional template
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    // scopedId
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        // server build
        hook = function (context) {
            // 2.3 injection
            context =
                context || // cached call
                    (this.$vnode && this.$vnode.ssrContext) || // stateful
                    (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
            // 2.2 with runInNewContext: true
            if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                context = __VUE_SSR_CONTEXT__;
            }
            // inject component styles
            if (style) {
                style.call(this, createInjectorSSR(context));
            }
            // register component module identifier for async chunk inference
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        // used by ssr in case component is cached and beforeCreate
        // never gets called
        options._ssrRegister = hook;
    }
    else if (style) {
        hook = shadowMode
            ? function (context) {
                style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
            }
            : function (context) {
                style.call(this, createInjector(context));
            };
    }
    if (hook) {
        if (options.functional) {
            // register for functional component in vue file
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        }
        else {
            // inject component registration as beforeCreate hook
            const existing = options.beforeCreate;
            options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
        }
    }
    return script;
}

const isOldIE = typeof navigator !== 'undefined' &&
    /msie [6-9]\\b/.test(navigator.userAgent.toLowerCase());
function createInjector(_context) {
    return (id, style) => addStyle(id, style);
}
let HEAD;
const styles = {};
function addStyle(id, css) {
    const group = isOldIE ? css.media || 'default' : id;
    const style = styles[group] || (styles[group] = { ids: new Set(), styles: [] });
    if (!style.ids.has(id)) {
        style.ids.add(id);
        let code = css.source;
        if (css.map) {
            // https://developer.chrome.com/devtools/docs/javascript-debugging
            // this makes source maps inside style tags work properly in Chrome
            code += '\n/*# sourceURL=' + css.map.sources[0] + ' */';
            // http://stackoverflow.com/a/26603875
            code +=
                '\n/*# sourceMappingURL=data:application/json;base64,' +
                    btoa(unescape(encodeURIComponent(JSON.stringify(css.map)))) +
                    ' */';
        }
        if (!style.element) {
            style.element = document.createElement('style');
            style.element.type = 'text/css';
            if (css.media)
                style.element.setAttribute('media', css.media);
            if (HEAD === undefined) {
                HEAD = document.head || document.getElementsByTagName('head')[0];
            }
            HEAD.appendChild(style.element);
        }
        if ('styleSheet' in style.element) {
            style.styles.push(code);
            style.element.styleSheet.cssText = style.styles
                .filter(Boolean)
                .join('\n');
        }
        else {
            const index = style.ids.size - 1;
            const textNode = document.createTextNode(code);
            const nodes = style.element.childNodes;
            if (nodes[index])
                style.element.removeChild(nodes[index]);
            if (nodes.length)
                style.element.insertBefore(textNode, nodes[index]);
            else
                style.element.appendChild(textNode);
        }
    }
}

/* script */
const __vue_script__ = script;

/* template */
var __vue_render__ = function() {
  var _h = this.$createElement;
  var _c = this._self._c || _h;
  return _c("div", { attrs: { id: "app" } }, [
    _c("div", { staticClass: "header" }, [
      _c(
        "button",
        { staticClass: "header-button", on: { click: this.saveToClient } },
        [this._v("Save")]
      ),
      this._v(" "),
      _c(
        "button",
        { staticClass: "header-button", on: { click: this.readFiles } },
        [this._v("\n      Load from file...\n    ")]
      ),
      this._v(" "),
      _c("input", {
        ref: "filePicker",
        staticStyle: { display: "none" },
        attrs: { type: "file" },
        on: { change: this.read }
      })
    ]),
    this._v(" "),
    this._m(0)
  ])
};
var __vue_staticRenderFns__ = [
  function() {
    var _h = this.$createElement;
    var _c = this._self._c || _h;
    return _c("div", { staticClass: "content" }, [
      _c("div", { attrs: { id: "editor" } })
    ])
  }
];
__vue_render__._withStripped = true;

  /* style */
  const __vue_inject_styles__ = (inject) => {
    if (!inject) return
    inject("data-v-a6038b52_0", { source: ":root {\n  --keyColor: #fa2d48;\n}\nbody,\nhtml {\n  margin: 0;\n  padding: 0;\n}\n#app {\n  height: 100%;\n  width: 100%;\n  position: absolute;\n  inset: 0;\n  display: grid;\n  grid-template-rows: 42px 1fr;\n}\n.header {\n  background: #222;\n  padding: 6px;\n  cursor: default;\n  user-select: none;\n}\n.content {\n  position: relative;\n}\n#editor {\n  position: absolute;\n  inset: 0;\n}\n.header-button {\n  appearance: none;\n  height: 100%;\n  font-family: \"Segoe UI Variable Display\", system-ui;\n  border: 0px;\n  border-radius: 3px;\n  padding: 6px 12px;\n  font-weight: 500;\n  background: #c8c8c8;\n}\n.header-button:hover {\n  background: var(--keyColor);\n  color: white;\n}\n\n/*# sourceMappingURL=pen.vue.map */", map: {"version":3,"sources":["/tmp/codepen/vuejs/src/pen.vue","pen.vue"],"names":[],"mappings":"AAuFA;EACA,mBAAA;ACtFA;ADwFA;;EAEA,SAAA;EACA,UAAA;ACrFA;ADuFA;EACA,YAAA;EACA,WAAA;EACA,kBAAA;EACA,QAAA;EACA,aAAA;EACA,4BAAA;ACpFA;ADuFA;EACA,gBAAA;EACA,YAAA;EACA,eAAA;EACA,iBAAA;ACpFA;ADuFA;EACA,kBAAA;ACpFA;ADuFA;EACA,kBAAA;EACA,QAAA;ACpFA;ADuFA;EACA,gBAAA;EACA,YAAA;EACA,mDAAA;EACA,WAAA;EACA,kBAAA;EACA,iBAAA;EACA,gBAAA;EACA,mBAAA;ACpFA;ADqFA;EACA,2BAAA;EACA,YAAA;ACnFA;;AAEA,kCAAkC","file":"pen.vue","sourcesContent":["<!-- Use preprocessors via the lang attribute! e.g. <template lang=\"pug\"> -->\n<template>\n  <div id=\"app\">\n    <div class=\"header\">\n      <button class=\"header-button\" @click=\"saveToClient\">Save</button>\n      <button class=\"header-button\" @click=\"exportFile\">Export...</button>\n      <button class=\"header-button\" @click=\"readFiles\">\n        Load from file...\n      </button>\n      <input\n        style=\"display: none\"\n        ref=\"filePicker\"\n        type=\"file\"\n        @change=\"read\"\n      />\n    </div>\n    <div class=\"content\">\n      <div id=\"editor\"></div>\n    </div>\n  </div>\n</template>\n\n<script>\nfunction saveTextAsFile(textToWrite, fileNameToSaveAs)\n    {\n    \tvar textFileAsBlob = new Blob([textToWrite], {type:'text/s  css'}); \n    \tvar downloadLink = document.createElement(\"a\");\n    \tdownloadLink.download = fileNameToSaveAs;\n    \tdownloadLink.innerHTML = \"Download File\";\n    \tif (window.webkitURL != null)\n    \t{\n    \t\t// Chrome allows the link to be clicked\n    \t\t// without actually adding it to the DOM.\n    \t\tdownloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);\n    \t}\n    \telse\n    \t{\n    \t\t// Firefox requires the link to be added to the DOM\n    \t\t// before it can be clicked.\n    \t\tdownloadLink.href = window.URL.createObjectURL(textFileAsBlob);\n    \t\tdownloadLink.onclick = destroyClickedElement;\n    \t\tdownloadLink.style.display = \"none\";\n    \t\tdocument.body.appendChild(downloadLink);\n    \t}\n    \n    \tdownloadLink.click();\n    }  \n  \nexport default {\n  data() {\n    return {\n      message: \"Welcome to Vue!\",\n      editor: null\n    };\n  },\n  mounted() {\n    this.editor = ace.edit(\"editor\");\n    this.editor.setTheme(\"ace/theme/monokai\");\n    this.editor.session.setMode(\"ace/mode/scss\");\n  },\n  methods: {\n    readFiles() {\n      this.$refs.filePicker.click();\n    },\n    exportFile() {\n      saveTextAsFile(this.editor.getValue(), prompt(\"Enter a file name, followed by .scss\"))\n    },\n    async read(input) {\n      console.log(\"READ\", this.$refs.filePicker.files);\n      function readFile(file) {\n        return new Promise((resolve, reject) => {\n          let fr = new FileReader();\n          fr.onload = (x) => resolve(fr.result);\n          fr.readAsText(file);\n        });\n      }\n      this.editor.setValue(await readFile(this.$refs.filePicker.files[0]));\n    },\n    saveToClient() {\n      alert(this.editor.getValue());\n    }\n  }\n};\n</script>\n\n<!-- Use preprocessors via the lang attribute! e.g. <style lang=\"scss\"> -->\n<style lang=\"scss\">\n:root {\n  --keyColor: #fa2d48;\n}\nbody,\nhtml {\n  margin: 0;\n  padding: 0;\n}\n#app {\n  height: 100%;\n  width: 100%;\n  position: absolute;\n  inset: 0;\n  display: grid;\n  grid-template-rows: 42px 1fr;\n}\n\n.header {\n  background: #222;\n  padding: 6px;\n  cursor: default;\n  user-select: none;\n}\n\n.content {\n  position: relative;\n}\n\n#editor {\n  position: absolute;\n  inset: 0;\n}\n\n.header-button {\n  appearance: none;\n  height: 100%;\n  font-family: \"Segoe UI Variable Display\", system-ui;\n  border: 0px;\n  border-radius: 3px;\n  padding: 6px 12px;\n  font-weight: 500;\n  background: rgb(200, 200, 200);\n  &:hover {\n    background: var(--keyColor);\n    color: white;\n  }\n}\n</style>\n",":root {\n  --keyColor: #fa2d48;\n}\n\nbody,\nhtml {\n  margin: 0;\n  padding: 0;\n}\n\n#app {\n  height: 100%;\n  width: 100%;\n  position: absolute;\n  inset: 0;\n  display: grid;\n  grid-template-rows: 42px 1fr;\n}\n\n.header {\n  background: #222;\n  padding: 6px;\n  cursor: default;\n  user-select: none;\n}\n\n.content {\n  position: relative;\n}\n\n#editor {\n  position: absolute;\n  inset: 0;\n}\n\n.header-button {\n  appearance: none;\n  height: 100%;\n  font-family: \"Segoe UI Variable Display\", system-ui;\n  border: 0px;\n  border-radius: 3px;\n  padding: 6px 12px;\n  font-weight: 500;\n  background: #c8c8c8;\n}\n.header-button:hover {\n  background: var(--keyColor);\n  color: white;\n}\n\n/*# sourceMappingURL=pen.vue.map */"]}, media: undefined });

  };
  /* scoped */
  const __vue_scope_id__ = undefined;
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = false;
  /* style inject SSR */

  /* style inject shadow dom */



  const __vue_component__ = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    false,
    createInjector,
    undefined,
    undefined
  );

export default __vue_component__;
